/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.VersionHelpers;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.Immutable;
import oshi.driver.windows.wmi.Win32VideoController;
import oshi.hardware.GraphicsCard;
import oshi.hardware.common.AbstractGraphicsCard;
import oshi.util.ParseUtil;
import oshi.util.Util;
import oshi.util.platform.windows.WmiUtil;
import oshi.util.tuples.Triplet;

@Immutable
final class WindowsGraphicsCard
extends AbstractGraphicsCard {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsGraphicsCard.class);
    private static final boolean IS_VISTA_OR_GREATER = VersionHelpers.IsWindowsVistaOrGreater();
    public static final String ADAPTER_STRING = "HardwareInformation.AdapterString";
    public static final String DRIVER_DESC = "DriverDesc";
    public static final String DRIVER_VERSION = "DriverVersion";
    public static final String VENDOR = "ProviderName";
    public static final String QW_MEMORY_SIZE = "HardwareInformation.qwMemorySize";
    public static final String MEMORY_SIZE = "HardwareInformation.MemorySize";
    public static final String DISPLAY_DEVICES_REGISTRY_PATH = "SYSTEM\\CurrentControlSet\\Control\\Class\\{4d36e968-e325-11ce-bfc1-08002be10318}\\";

    WindowsGraphicsCard(String string, String string2, String string3, String string4, long l) {
        super(string, string2, string3, string4, l);
    }

    public static List<GraphicsCard> getGraphicsCards() {
        String[] stringArray;
        ArrayList<GraphicsCard> arrayList = new ArrayList<GraphicsCard>();
        int n = 1;
        for (String string : stringArray = Advapi32Util.registryGetKeys(WinReg.HKEY_LOCAL_MACHINE, DISPLAY_DEVICES_REGISTRY_PATH)) {
            if (!string.startsWith("0")) continue;
            try {
                String string2 = DISPLAY_DEVICES_REGISTRY_PATH + string;
                if (!Advapi32Util.registryValueExists(WinReg.HKEY_LOCAL_MACHINE, string2, ADAPTER_STRING)) continue;
                String string3 = Advapi32Util.registryGetStringValue(WinReg.HKEY_LOCAL_MACHINE, string2, DRIVER_DESC);
                String string4 = "VideoController" + n++;
                String string5 = Advapi32Util.registryGetStringValue(WinReg.HKEY_LOCAL_MACHINE, string2, VENDOR);
                String string6 = Advapi32Util.registryGetStringValue(WinReg.HKEY_LOCAL_MACHINE, string2, DRIVER_VERSION);
                long l = 0L;
                if (Advapi32Util.registryValueExists(WinReg.HKEY_LOCAL_MACHINE, string2, QW_MEMORY_SIZE)) {
                    l = Advapi32Util.registryGetLongValue(WinReg.HKEY_LOCAL_MACHINE, string2, QW_MEMORY_SIZE);
                } else if (Advapi32Util.registryValueExists(WinReg.HKEY_LOCAL_MACHINE, string2, MEMORY_SIZE)) {
                    Object object = Advapi32Util.registryGetValue(WinReg.HKEY_LOCAL_MACHINE, string2, MEMORY_SIZE);
                    if (object instanceof Long) {
                        l = (Long)object;
                    } else if (object instanceof Integer) {
                        l = Integer.toUnsignedLong((Integer)object);
                    } else if (object instanceof byte[]) {
                        byte[] byArray = (byte[])object;
                        l = ParseUtil.byteArrayToLong(byArray, byArray.length, false);
                    }
                }
                arrayList.add(new WindowsGraphicsCard(Util.isBlank(string3) ? "unknown" : string3, Util.isBlank(string4) ? "unknown" : string4, Util.isBlank(string5) ? "unknown" : string5, Util.isBlank(string6) ? "unknown" : string6, l));
            }
            catch (Win32Exception win32Exception) {
                if (win32Exception.getErrorCode() == 5) continue;
                throw win32Exception;
            }
        }
        if (arrayList.isEmpty()) {
            return WindowsGraphicsCard.getGraphicsCardsFromWmi();
        }
        return arrayList;
    }

    private static List<GraphicsCard> getGraphicsCardsFromWmi() {
        ArrayList<GraphicsCard> arrayList = new ArrayList<GraphicsCard>();
        if (IS_VISTA_OR_GREATER) {
            WbemcliUtil.WmiResult<Win32VideoController.VideoControllerProperty> wmiResult = Win32VideoController.queryVideoController();
            for (int i = 0; i < wmiResult.getResultCount(); ++i) {
                String string;
                String string2 = WmiUtil.getString(wmiResult, Win32VideoController.VideoControllerProperty.NAME, i);
                Triplet<String, String, String> triplet = ParseUtil.parseDeviceIdToVendorProductSerial(WmiUtil.getString(wmiResult, Win32VideoController.VideoControllerProperty.PNPDEVICEID, i));
                String string3 = triplet == null ? "unknown" : triplet.getB();
                String string4 = WmiUtil.getString(wmiResult, Win32VideoController.VideoControllerProperty.ADAPTERCOMPATIBILITY, i);
                if (triplet != null) {
                    if (Util.isBlank(string4)) {
                        string3 = triplet.getA();
                    } else {
                        string4 = string4 + " (" + triplet.getA() + ")";
                    }
                }
                string = !Util.isBlank(string = WmiUtil.getString(wmiResult, Win32VideoController.VideoControllerProperty.DRIVERVERSION, i)) ? "DriverVersion=" + string : "unknown";
                long l = WmiUtil.getUint32asLong(wmiResult, Win32VideoController.VideoControllerProperty.ADAPTERRAM, i);
                arrayList.add(new WindowsGraphicsCard(Util.isBlank(string2) ? "unknown" : string2, string3, Util.isBlank(string4) ? "unknown" : string4, string, l));
            }
        }
        return arrayList;
    }
}

