/*
 * Decompiled with CFR 0.152.
 */
package de.jcm.discordgamesdk.impl.channel;

import de.jcm.discordgamesdk.impl.channel.DiscordChannel;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class WindowsDiscordChannel
implements DiscordChannel {
    private final FileChannel channel;
    private boolean blocking = true;
    private String path = System.getenv("DISCORD_IPC_PATH");

    public WindowsDiscordChannel() throws IOException {
        Object object;
        if (this.path == null) {
            object = System.getenv("DISCORD_INSTANCE_ID");
            int n = 0;
            if (object != null) {
                n = Integer.parseInt((String)object);
            }
            this.path = "\\\\.\\\\pipe\\\\discord-ipc-" + n;
        }
        object = new RandomAccessFile(this.path, "rw");
        this.channel = ((RandomAccessFile)object).getChannel();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public void configureBlocking(boolean bl) throws IOException {
        this.blocking = bl;
    }

    @Override
    public boolean isAvailable() {
        return new File(this.path).exists() && this.channel.isOpen();
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int n = 0;
        if (this.blocking || this.channel.size() - this.channel.position() >= (long)byteBuffer.remaining()) {
            n = this.channel.read(byteBuffer);
        }
        return n;
    }

    @Override
    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        long l = 0L;
        long l2 = 0L;
        for (int i = n; !this.blocking && i < n + n2; ++i) {
            l2 += (long)byteBufferArray[i].remaining();
        }
        if (this.blocking || this.channel.size() - this.channel.position() >= l2) {
            l = this.channel.read(byteBufferArray, n, n2);
        }
        return l;
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        int n = this.channel.write(byteBuffer);
        this.channel.force(false);
        return n;
    }
}

